﻿using System.Text.RegularExpressions;
using Tags.ID3;

namespace MP3修改工具
{
    public class MYMP3 : ID3v1
    {
        private int _id;
        private string _Number;

        public MYMP3(string FilePath, bool LoadData) : base(FilePath, LoadData)
        {
            Match match = Regex.Match(base.FileName, @"\d+", RegexOptions.IgnoreCase);
            if (((match != null) && (match.Value != null)) && Regex.IsMatch(match.Value, "^[-]?[0-9]*$"))
            {
                this._Number = match.Value;
            }
            else
            {
                this._Number = "0";
            }
        }

        public int Id
        {
            get
            {
                return this._id;
            }
            set
            {
                this._id = value;
            }
        }

        public string Number
        {
            get
            {
                if (this._Number.Length == 1)
                {
                    this._Number = "00" + this._Number;
                }
                else if (this._Number.Length == 2)
                {
                    this._Number = "0" + this._Number;
                }
                return this._Number;
            }
            set
            {
                this._Number = value;
            }
        }
    }
}
